﻿var users = {
    context: $(".v-users"),
    canModifySettings: $("#ModifyReportingAccess").val() == "True",
    datatable: null,
    refreshDataTable: function () {
        users.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-usersTable").a4datatable({
            advancedFilter: true,
            height: "full",
            stateKey: "PortalUsers",
            ajaxAction: a4.getAction("GetUsers", "Reporting", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true},
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName", "HideInSelector": true },
                { "Name": "FirstName", "Title": resources.FirstName, "Data": "FirstName" },
                { "Name": "LastName", "Title": resources.LastName, "Data": "LastName" },
                { "Name": "Active", "Title": resources.Status, "Data": "ActiveLabel", "Type": "boolean", "AdvancedFilterLabels": { "0": resources.Inactive, "1": resources.Active } },
                { "Name": "CompanyName", "Title": resources.CompanyName, "Data": "CompanyName" }
            ],
            toolBarItems: users.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "sendEmail":
                        users.sendEmailInvitation(ids);
                        break;
                    case "delete":
                        users.deleteItems(ids);
                        break;
                }
            },
            contextMenuItems: users.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var id = [row.Id];

                switch (action) {
                    case "properties":
                        modalDialog.showWindow(a4.getAction("EditUser", "Reporting", "Settings", { id: row.Id }), 600, 800, { afterClose: function () { users.refreshDataTable(); } });
                        break;
                    case "sendEmail":
                        users.sendEmailInvitation(id);
                        break;
                    case "delete":
                        users.deleteItems(id);
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.Active, "AjaxParams": { "active": true } },
                    { "Label": resources.Inactive, "AjaxParams": { "active": false } }
                ]
            },
            localizableTexts: { "All": resources.AllUsers, "Search": resources.SearchUsers }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addUser", function () {
            modalDialog.showWindow(a4.getAction("EditUser", "Reporting", "Settings"), 600, 800, { afterClose: function () { users.refreshDataTable(); } });
        });
    },
    deleteItems: function (items) {
        modalDialog.showConfirmDelete(confirmDeletePortalUsersResources, function () {
            a4.callServerMethod(a4.getAction("DeleteUsers", "Reporting", "Settings"), { ids: items },
                function (result) {
                    users.refreshDataTable();
                });
        }, items.length);
    },
    sendEmailInvitation: function (items) {
        modalDialog.showConfirmDialog(confirmSendEmailResources, function () {
            a4.callServerMethod(a4.getAction("SendEmailInvitationToUsers", "Reporting", "Settings"), { ids: items }, function (result) {
                users.refreshDataTable();
            });
        }, 220, 500, false, {});
    },
    getContextMenuItems: function () {
        var items = [];

        if (this.canModifySettings) {
            items = [
                { "Action": "sendEmail", "Label": resources.SendEmail },
                { "Divider": true },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "properties", "Label": resources.Properties }
            ]
        }

        return items;
    },
    getToolBarItems: function () {
        var items = [];

        if (this.canModifySettings) {
            items = [
               { "Action": "sendEmail", "Label": resources.SendEmail },
               { "Action": "delete", "Label": resources.Delete }
            ]
        }

        return items;
    }
}

$(document).ready(function () {
    if (users.context.length > 0) {
        users.initializeDataTable();
        users.bindEvents();
    }
});


